/*
	File: CEG_common.sqf
	Version: 1.1
	Author: Loyalguard

	Description:
	A script to initialize all the required SP, MP host, and MP client-side components of the CEG simulation.

	Parameters:
	None.
	
	Execution:
	Executed from CEG_server.sqf or CEG_client.sqf  Will only run on SP, MP hosts, and MP clients due to conditions checked in the executing instance.	
*/

if (!isNil "CEG_DEBUG") then {_debug = ["CEG_common.sqf: Thread started."] call LGD_fnc_debugMessage;}; //DEBUG
 
// Scope //
private ["_obj", "_class", "_action", "_effect", "_logic", "_trip", "_close"];

// If the mission maker has not disabled the option (by declaring CEG_manual = false in the init.sqf), then allow players to manually trip and close circuit breakers to cut off and restore power.	
if (isNil "CEG_manual") then {CEG_manual = true};	

// Begin a forEach loop to perform several different functions for the CEG simulation.
{ 
	// Assign local variables to elements extracted from the CEG_objects array in this iteration of the forEach loop.
	_obj = (_x select 0); // "objectName_location".
	_class = (_x select 2); // "ClassName" of object.
	_action = (_x select 3); // Boolean whether or not this object get an action menu command added to it.
	_effect = (_x select 4); // Effect (sound or particles) associated with object.
	_logic = missionNameSpace getVariable (format ["CEG_logic_%1", _obj]); // Get the name of logic assigned to this object.
	
	// If designated in the CEG_objects array, give this object an action menu command to trip/open or close a circuit breaker for a substation transformer to cutoff outgoing power (to other transformers/substations and/or street lamps).  The appropriate action will only be seen only if the mission maker has not disabled it,  if the it matches to the current boolean state, and the unit is close enough to the memory point of the object for action commands.
	if (_action) then
	{
		_trip = (position _logic nearestObject _class) addAction ["Trip Circuit Breaker", "CEG\Scripts\CEG_actions.sqf", _obj, 6, true, true, "", (format ["((CEG_manual) && (CEG_out_%1) && ((_this distance _target) < 7))", _obj])];
			
		_close = (position _logic nearestObject _class) addAction ["Close Circuit Breaker", "CEG\Scripts\CEG_actions.sqf", _obj, 6, true, true, "", (format ["((CEG_manual) && (!CEG_out_%1) && ((_this distance _target) < 7))", _obj])];
	};
	
	// Determine which effect (if any) has been assigned to this CEG object as designated in the CEG_objects array: Transformer hum sound, power plant noise sound, or smoke particles eminating from the plant's smokestack.		
	switch (_effect) do
	{
		case "XFMR":
		{
			_nul = ["XFMR", _obj] execVM "CEG\Scripts\CEG_sounds.sqf";
		};
				
		case "PLANT":
		{
			_nul = ["PLANT", _obj] execVM "CEG\Scripts\CEG_sounds.sqf";
		};
				
		case "SMOKE":
		{
			_nul = [_obj] execVM "CEG\Scripts\CEG_smoke.sqf";
		};
	};

	sleep .01;
	
} forEach CEG_objects; // CEG_objects was initialized in CEG_init.sqf.
 
if (!isNil "CEG_DEBUG") then {_debug = ["CEG_common.sqf: Thread finished."] call LGD_fnc_debugMessage;}; //DEBUG